package sklep.rest;

import java.util.List;
import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

import sklep.model.Order;
import sklep.repository.OrderRepository;

@RestController
@RequestMapping("/rest/orders")
public class OrderEndpoint {
    @Autowired
    private OrderRepository orderRepository;
    
    @GetMapping
    public List<Order> readAll() {
        return orderRepository.findAll();
    }
    
    @GetMapping("/{id}")
    public Order readOne(@PathVariable("id") int id) {
        Optional<Order> order = orderRepository.findById(id);
        if(order.isPresent()) {
            return order.get();
        } else {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Nie ma zamówienia o numerze " + id);
        }
    }
        
}
