package sklep.rest;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

import sklep.model.Customer;
import sklep.repository.CustomerRepository;

@RestController
@RequestMapping("/rest/customers")
public class CustomerEndpoint {
    @Autowired
    private CustomerRepository customerRepository;

    @GetMapping
    public List<Customer> listaKlientow(Model model) {
        return customerRepository.findAll();
    }

    @GetMapping("/{email}")
    public Customer jedenKlient(Model model, @PathVariable("email") String email) {
        return customerRepository.findById(email).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND));
    }

}
