package sklep.controller;

import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.time.LocalDateTime;

@Controller
public class RootController {
    @GetMapping("/")
    public String index() {
        return "index";
    }

    @GetMapping(path="/hello", produces="text/plain")
    @ResponseBody
    public String hello() {
        return "Hello world";
    }

    @GetMapping("/czas")
    public String odczytajCzasJsp(Model model) {
        model.addAttribute("dt", LocalDateTime.now());
        return "wyswietl_czas";
    }

    @GetMapping("/whoami")
    public String whoAmI(Authentication authentication, Model model) {
        if(authentication != null && authentication.isAuthenticated()) {
            model.addAttribute("userName", authentication.getName());
            model.addAttribute("authorities", authentication.getAuthorities());
        }
        return "whoami";
    }
}
