package alx.aplikacja.waluty;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class WalutyController {
    /* @Autowired oznacza, że Spring wstawi do tej zmiennej referencję do obiektu tego typu.
     * Gdyby nie potrafił tego zrobić, to aplikacja się nie uruchomi. Pole nie zostanie pozostawione z nullem.
     * 
     * To się nazywa "wstrzykiwanie zależności" / dependency injection.
     * Są 3 sposoby wstrzykiwania , o 2 pozostałych później.
     * Wstrzykiwanie zal. działa tylko gdy obiekt tej klasy jest inicjalizowany przez Springa.
     * 
     * Wstrzykiwać można obiekty, które są typu:
     * - komponent (bean) istniejący w tej samej aplikacji (tak jest tutaj)
     * - klasa o specjalnym znaczeniu, którą Spring "zna", np. ServletContext
     * 
     * W miejscu użycia zmienna może być typu interfejsowego,
     * a Spring wstawi "jakąś implementację" tego interfejsu,
     * jeśli taka implementacja jest dostępna wśród komponentów (beanów).
     */
    
    @Autowired
    private PobieranieWalut pobieracz;
    
    @GetMapping("/waluty")
    public String wyswietlWaluty(String data, Model model) {
        TabelaWalut tabela;
        if(data == null) {
            tabela = pobieracz.pobierzBiezaceKursy();
        } else {
            tabela = pobieracz.pobierzArchiwalneKursy(data);
        }
        model.addAttribute("tabela", tabela);
        return "waluty.html";
    }

}
