package alx.aplikacja.waluty;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.LocalDate;

import org.springframework.stereotype.Service;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;

@Service
public class PobieranieJSON implements PobieranieWalut {

    private static final String ADRES = "http://api.nbp.pl/api/exchangerates/tables";

    public TabelaWalut pobierzBiezaceKursy() {
        return pobierzJsonZAdresu(ADRES + "/a/?format=json");
    }
    
    public TabelaWalut pobierzArchiwalneKursy(String data) {
        return pobierzJsonZAdresu(ADRES + "/a/" + data + "?format=json");
    }

    private TabelaWalut pobierzJsonZAdresu(String adres) {
        try {
            URL url = new URL(adres);
            try(InputStream input = url.openStream()) {
                return wczytajStream(input);
            }
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static TabelaWalut wczytajStream(InputStream input) {
        try(JsonReader reader = Json.createReader(input)) {
            // dokument zawiera [tablicę], a ta tablica zawiera {obiekt}
            JsonArray array = reader.readArray();
            JsonObject tabela = array.getJsonObject(0);
            String typ = tabela.getString("table");
            String numer = tabela.getString("no");
            LocalDate data = LocalDate.parse(tabela.getString("effectiveDate"));
            JsonArray waluty = tabela.getJsonArray("rates");

            TabelaWalut wynikowaTabela = new TabelaWalut(typ, numer, data);
            for(JsonValue jsonValue : waluty) {
                JsonObject jsonObject = jsonValue.asJsonObject();
                Waluta waluta = new Waluta(jsonObject.getString("code"),
                        jsonObject.getString("currency"),
                        jsonObject.getJsonNumber("mid").bigDecimalValue());
                wynikowaTabela.dodajWalute(waluta);
            }
            
            return wynikowaTabela;
        }
    }
}
