package alx.aplikacja;

import org.springframework.stereotype.Component;

/* Adnotacja @Component (albo alternatywnie @Service, @Repository) powoduje, że:
1. na starcie aplikacji Spring twozy obiekt tej klasy i go "rejestruje" jako komponent / bean
2. gdy inne klasy będą się odpowiednio odwoływać do tej klasy, to Spring "wstrzyknie" referencję do tego obiektu
*/

@Component
public class LogikaKalkulatora {

    public long oblicz(long liczba1, long liczba2, String operacja) {
        return switch (operacja) {
            case "+" -> liczba1 + liczba2;
            case "-" -> liczba1 - liczba2;
            case "*" -> liczba1 * liczba2;
            case "/" -> liczba1 / liczba2;
            default -> 0;
        };
    }
}
