package alx.aplikacja;

import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class KalkulatorController {
    @Autowired
    private LogikaKalkulatora logikaKalkulatora;

    @GetMapping("/kalkulator")
    public String dzialaj(Long liczba1, Long liczba2, String operacja, Model model) {
        if(ObjectUtils.allNotNull(liczba1, liczba2, operacja)) {
            long wynik = logikaKalkulatora.oblicz(liczba1, liczba2, operacja);
            model.addAttribute("wynik", wynik);
        }
        return "kalkulator.html";
    }
}
