package sklep.serwlety;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import sklep.model.Product;

// Wersja ze wstrzykiwaniem EntityManager (a nie fabryki) za pomocą adnotacji @PersistenceContext.
// Jeśli w aplikacji jest tylko jeden persistence unit, to nazwy można nie podawać, ale ja wolę zawsze podać.
// Ta wersja jest odpowiednia dla konfiguracji opartej o JTA

@WebServlet("/lista3")
public class Lista3 extends HttpServlet {
    private static final long serialVersionUID = 1L;
    
    @PersistenceContext(unitName="sklep")
    private EntityManager em;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        
        try {
            TypedQuery<Product> query = em.createNamedQuery("Product.findAll", Product.class);
            List<Product> products = query.getResultList();
            out.println("Odczytano " + products.size() + " rekordów:");
            for (Product product : products) {
                out.println(product.getProductName() + " " + product.getPrice());
            }
        } catch(Exception e) {
            out.println("Wyjątek: " + e + "\n");
            e.printStackTrace(out);
        }
    }

}
