package sklep.programy;

import java.math.BigDecimal;
import java.util.List;
import java.util.Scanner;

import jakarta.persistence.*;

import sklep.model.Product;

public class P06_Parametry {

    public static void main(String[] args) {
        try (EntityManagerFactory emf = Persistence.createEntityManagerFactory("sklep_pu");
             EntityManager em = emf.createEntityManager();
             Scanner scanner = new Scanner(System.in)) {

            System.out.print("Podaj cenę minimalną: ");
            BigDecimal min = scanner.nextBigDecimal();
            System.out.print("Podaj cenę maksymalną: ");
            BigDecimal max = scanner.nextBigDecimal();

            TypedQuery<Product> query = em.createQuery(
                    "SELECT p FROM Product p WHERE p.price BETWEEN :minimum AND :maximum ORDER BY p.price DESC", Product.class);
            query.setParameter("minimum", min);
            query.setParameter("maximum", max);
            List<Product> products = query.getResultList();
            for (Product product : products) {
                // System.out.println(product);
                System.out.println(product.getProductName() + " za cenę " + product.getPrice());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
