package sklep.programy;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.TypedQuery;
import sklep.model.Product;

import java.util.List;

// JPQL = Java (Jakarta) Persistence Query Language
// Język wzorowany na SQL, ale odnoszący się do klas i obiektów w Javie,
// pozwalający wykonywać dowolne zapytania i polecenia na bazie danych poprzez JPA/Hibernate.
public class P04_WszystkieProdukty_JPQL {

    public static void main(String[] args) {
        try(EntityManagerFactory emf = Persistence.createEntityManagerFactory("sklep_pu");
            EntityManager em = emf.createEntityManager()
        ) {
            TypedQuery<Product> query = em.createQuery("SELECT p FROM Product p ORDER BY p.id", Product.class);
            List<Product> products = query.getResultList();
            System.out.println("Odczytano " + products.size() + " rekordów:");
            for (Product product : products) {
                System.out.println(product.getProductName() + " za cenę " + product.getPrice());
            }
        }
    }
}
