package sklep.przyklady_hibernate;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.TypedQuery;
import sklep.model.Product;

public class OdczytajListe_Stream {

    public static void main(String[] args) {
        try(EntityManagerFactory emf = Persistence.createEntityManagerFactory("sklep");
            EntityManager em = emf.createEntityManager()) {
            
            TypedQuery<Product> query = em.createNamedQuery("Product.findAll", Product.class);
            query.getResultStream()
                    .forEachOrdered(product -> System.out.printf("%s za cenę %s\n",
                                        product.getProductName(), product.getPrice()));
        }
    }

}
