package hr.programy;

import java.util.List;

import javax.swing.JOptionPane;

import hr.model.Employee;
import jakarta.persistence.*;

public class P05_Warunek {

    public static void main(String[] args) {
        EntityManagerFactory emf = null;
        EntityManager em = null ;
        try {
            emf = Persistence.createEntityManagerFactory("hr_postgresql");
            em = emf.createEntityManager();
            
            String szukaneMiasto = JOptionPane.showInputDialog("Podaj miasto", "Seattle");
            
            TypedQuery<Employee> query = em.createQuery(
                    "SELECT emp FROM Employee emp WHERE emp.department.location.city = :miasto",
                    Employee.class);
            query.setParameter("miasto", szukaneMiasto);
            List<Employee> emps = query.getResultList();
            System.out.println("Ilość rekordów " + emps.size());
            for (Employee emp : emps) {
                System.out.println(emp.getFirstName() + " " + emp.getLastName());
            }
        } finally {
            em.close();
            emf.close();            
        }
    }

}
