package hr.programy;

import java.util.List;

import hr.model.Location;
import jakarta.persistence.*;

public class P03_OdczytajListe_NamedQuery {

    public static void main(String[] args) {
        EntityManagerFactory emf = null;
        EntityManager em = null ;
        try {
            emf = Persistence.createEntityManagerFactory("hr_postgresql");
            em = emf.createEntityManager();
            TypedQuery<Location> query = em.createNamedQuery("Location.findAll", Location.class);
            List<Location> locations = query.getResultList();
            for (Location loc : locations) {
                System.out.printf(" - %s, %s %s, %s\n", loc.getStreetAddress(), loc.getPostalCode(), loc.getCity(),
                        loc.getCountry().getCountryName());
            }
        } finally {
            em.close();
            emf.close();            
        }
    }

}
