package hr.programy;

import java.util.List;

import hr.model.Location;
import jakarta.persistence.*;
import hr.model.*;

public class P02_OdczytajListe_JPQL {

    public static void main(String[] args) {
        EntityManagerFactory emf = null;
        EntityManager em = null ;
        try {
            emf = Persistence.createEntityManagerFactory("hr_postgresql");
            em = emf.createEntityManager();
            // JPQL = Java Persistence Query Language
            TypedQuery<Location> query = em.createQuery("SELECT loc FROM Location loc ORDER BY loc.country.countryId, loc.city", Location.class);
            List<Location> locations = query.getResultList();
            for (Location loc : locations) {
                System.out.printf(" - %s, %s %s, %s\n", loc.getStreetAddress(), loc.getPostalCode(), loc.getCity(),
                        loc.getCountry().getCountryName());
            }
        } finally {
            em.close();
            emf.close();            
        }
    }

}
