package hr.programy;

import java.util.Scanner;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import hr.model.Department;
import hr.model.Employee;

public class P01_OdczytajWgId {

    public static void main(String[] args) {
        System.out.println("Startujemy...");
        
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("hr_postgresql");
        EntityManager em = emf.createEntityManager();
        System.out.println("Mam EntityManagera: " + em);
        
        Scanner sc = new Scanner(System.in);
        while(true) {
            System.out.print("\nPodaj ID pracownika (0 kończy program): ");            
            Integer id = sc.nextInt();
            if(id == 0) break;
            Employee emp = em.find(Employee.class, id);
            System.out.println("Odczytany obiekt: " + emp);
            if(emp == null) {
                System.out.printf("Nie ma pracownika o id %d\n", id);
                continue;
            }
            System.out.printf("%s %s (%s) zarabia %s\n",
                    emp.getFirstName(), emp.getLastName(), emp.getJob().getJobTitle(), emp.getSalary());
            Department dep = emp.getDepartment();
            if(dep != null) {
               System.out.printf("Departament %s, %s, %s, %s\n",
                       dep.getDepartmentName(), dep.getLocation().getStreetAddress(),
                       dep.getLocation().getCity(), dep.getLocation().getCountry().getCountryName()); 
            }        
        }
        sc.close();
        em.close();
        emf.close();
        System.out.println("Koniec");
    }

}
