package rest;

import java.util.Arrays;
import java.util.Map;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;

@Path("/kontekst")
@Produces("text/plain")
public class Kontekst {
    @GET
    public String info(
        @Context UriInfo uriInfo,
        @Context SecurityContext securityContext,
        @Context Request restRequest,
        @Context HttpHeaders headers,
        @Context ServletContext servletContext,
        @Context ServletConfig servletConfig,
        @Context HttpServletRequest servletRequest,
        @Context HttpServletResponse servletResponse
    ) {
        StringBuilder b = new StringBuilder();
        
        b.append("UriInfo\n");
        b.append("Base URI     : ").append(uriInfo.getBaseUri()).append('\n');
        b.append("Absolute path: ").append(uriInfo.getAbsolutePath()).append('\n');
        b.append("Path         : ").append(uriInfo.getPath()).append('\n');
        
        b.append("\nHttpHeaders\n");
        b.append(headers.getRequestHeaders());

        // Request restRequest - wiąże się z obsługą keszowania i typów zawartości
        
        b.append("\nServletContext\n");
        b.append("ServlerInfo: ").append(servletContext.getServerInfo()).append('\n');
        
        b.append("\nServletRequest\n");
        b.append("RemoteAddr: ").append(servletRequest.getRemoteAddr()).append('\n');
        b.append("LocalAddr : ").append(servletRequest.getLocalAddr()).append('\n');
        b.append("URI       : ").append(servletRequest.getRequestURI()).append('\n');
        b.append("Parametry :\n");
        
        for (Map.Entry e : servletRequest.getParameterMap().entrySet()) {
            String[] v = (String[]) e.getValue();
            b.append(" * " + e.getKey() + " : " + Arrays.toString(v) + "\n");
        }
        
        b.append("\nZalogowany wg serwletu: ").append(servletRequest.getRemoteUser()).append('\n');
        b.append("Zalogowany wg SecurityContext: ").append(securityContext.getUserPrincipal()).append('\n');
        
        return b.toString();
    }

}
