package rest_klient;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import sklep.model.Product;

import java.util.Scanner;

public class Klient23_RestClient_JSON_JedenProdukt {

    public static void main(String[] args) {
        try(Client client = ClientBuilder.newClient();
                Scanner scanner = new Scanner(System.in)) {
            final WebTarget path = client.target(Ustawienia.ADRES_USLUGI)
                    .path("products")
                    .path("{id}");

            while (true) {
                System.out.print("Podaj id produktu (-1 kończy): ");
                int id = Integer.parseInt(scanner.nextLine());
                if (id == -1) {
                    break;
                }

                try (Response response = path
                        .resolveTemplate("id", id)
                        .request()
                        .accept(MediaType.APPLICATION_JSON)
                        .buildGet()
                        .invoke()) {

                    System.out.println("Mam odpowiedź: " + response);
                    System.out.println("Status: " + response.getStatus());
                    System.out.println("C-Type: " + response.getMediaType());
                    System.out.println("Length: " + response.getLength());

                    Product product = response.readEntity(Product.class);
                    System.out.println("Odczytany produkt: " + product);
                }
            }
        }
    }

}
