package rest_klient;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import jakarta.json.*;

public class Klient02_URL_JSON {
    /* W tej wersji pobieramy dane JSON podstawowym sposobem URL, ale pobrane dane parsujemy za pomocą narzędzi
       z biblioteki Jakarta JSON P - w tym projekcie dostępnej dzięki zależności eclipse parsson.
     */
    public static void main(String[] args) {
        try {
            URL url = new URL(Ustawienia.ADRES_USLUGI + "/products.json");
            try(InputStream inputStream = url.openStream();
                JsonReader reader = Json.createReader(inputStream)) {
                // pierwszym znakiem w odpowiedzi jest nawias kwadratowy, czyli należy wczytać tablicę jsonową
                JsonArray array = reader.readArray();
                // System.out.println(array);
                for(JsonValue jsonValue : array) {
                    //System.out.println(jsonValue);
                    JsonObject jsonObject = jsonValue.asJsonObject();
                    System.out.println(jsonObject.getString("productName"));
                    System.out.println("    opis: " + jsonObject.getString("description", ""));
                    System.out.println("    cena: " + jsonObject.getJsonNumber("price").bigDecimalValue());
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

}
