package sklep.rest;

import jakarta.ws.rs.*;
import sklep.db.DBConnection;
import sklep.db.DBException;
import sklep.db.ProductDAO;
import sklep.db.RecordNotFound;
import sklep.model.Product;
import sklep.model.ProductList;

@Path("/products.pdf")
@Produces("application/pdf")
public class RProductsPdf {
    @GET
    public ProductList allProducts() throws DBException {
        try(DBConnection db = DBConnection.open()) {
            ProductDAO productDAO = db.productDAO();
            return new ProductList(productDAO.readAll());
        }
    }

    @GET
    @Path("/{id}")
    // przykładowo /api/products.pdf/3
    public Product oneProduct(@PathParam("id") int productId) throws DBException, RecordNotFound {
        try(DBConnection db = DBConnection.open()) {
            ProductDAO productDAO = db.productDAO();
            return productDAO.findById(productId);
        }
    }
}
