package sklep.rest;

import jakarta.ws.rs.*;
import jakarta.ws.rs.core.Response;
import sklep.db.DBConnection;
import sklep.db.DBException;
import sklep.db.ProductDAO;
import sklep.db.RecordNotFound;
import sklep.model.Product;

import java.util.List;

@Path("/products.html")
@Produces("text/html;charset=UTF-8")
public class RProductsHtml {
    @GET
    public String allProducts() throws DBException {
        try(DBConnection db = DBConnection.open()) {
            ProductDAO productDAO = db.productDAO();
            List<Product> products = productDAO.readAll();
            StringBuilder txt = new StringBuilder("<!DOCTYPE html>\n<html><body>\n");
            txt.append("<h1>Lista produktów</h1>\n");
            for(Product product : products) {
                txt.append(product.toHtml()).append('\n');
            }
            txt.append("</body></html>");
            return txt.toString();
        }
    }

    // W tej metodzie pokazuję, jak wyglądaloby zwracanie różnych kodów odpowiedzi w zależności od sytuacji.
    // Używamy klasy Response
    @GET
    @Path("/{id}")
    public Response oneProduct(@PathParam("id") int productId) {
        try(DBConnection db = DBConnection.open()) {
            ProductDAO productDAO = db.productDAO();
            Product product = productDAO.findById(productId);
            return Response.ok()
                    .entity("<!DOCTYPE html>\n<html><body>" + product.toHtml() + "</body></html>")
                    .build();
        } catch (DBException e) {
            return Response.serverError()
                    .entity("<!DOCTYPE html>\n<html><body><p>WIELKA BIEDA</p></body></html>")
                    .build();
        } catch (RecordNotFound e) {
            return Response.status(404)
                    .entity("<!DOCTYPE html>\n<html><body><p>BRAK TAKIEGO PRODUKTU</p></body></html>")
                    .build();
        }
    }
}
