package sklep.klient;

import sklep.generated.DBException_Exception;
import sklep.generated.Product;
import sklep.generated.Sklep;
import sklep.generated.SklepService;

import java.util.List;

public class Klient1_WszystkieProdukty {

    public static void main(String[] args) {
        System.out.println("Początek programu");
        SklepService service = new SklepService();
        // tworzymy "obiekt proxy", za pośrednictwem którego klient może wywoływać metody na serwerze
        // ogólnie na takie rozwiązania mówi się "RPC - remote procedure call"
        // na interfejs Sklep mówi się "service endpoint interface - SEI"
        Sklep sklep = service.getSklepPort();
        System.out.println("Klient gotowy do pracy");

        try {
            List<Product> products = sklep.readAllProducts();
            for(Product product : products) {
                System.out.println(product.getProductName() + " za " + product.getPrice());
            }
        } catch (DBException_Exception e) {
            System.out.println("Błąd: " + e);
        }
        System.out.println("Koniec programu");
    }
}
