package sklep.soap;

import jakarta.jws.WebParam;
import jakarta.jws.WebResult;
import jakarta.jws.WebService;
import jakarta.xml.ws.soap.MTOM;
import sklep.db.*;
import sklep.model.*;

import java.math.BigDecimal;
import java.util.List;

// JAX-WS - Usługi SOAP w Javie
// JAXB ("XML Binding") - mapowanie obiektów Java na fragmenty XML
// Jeśli chcemy wpłynąć na postać XML, który powstaje z obiektów, to w klasach modelu należy dodać adnotacje JAXB
// @XmlElement, @XmlValue ...

@WebService
@MTOM
public class Sklep {

    @WebResult(name="product")
    public Product readProduct(@WebParam(name="id") int productId) throws DBException, RecordNotFound {
        try(DBConnection db = DBConnection.open()) {
            ProductDAO productDAO = db.productDAO();
            return productDAO.findById(productId );
        }
    }

    @WebResult(name="product")
    public List<Product> readAllProducts() throws DBException {
        try(DBConnection db = DBConnection.open()) {
            ProductDAO productDAO = db.productDAO();
            return productDAO.readAll();
        }
    }

    @WebResult(name="product")
    public List<Product> productsByPrice(@WebParam(name="min") BigDecimal min, @WebParam(name="max") BigDecimal max) throws DBException {
        try(DBConnection db = DBConnection.open()) {
            ProductDAO productDAO = db.productDAO();
            return productDAO.findByPrice(min, max);
        }
    }

    public void saveProduct(@WebParam(name="product") Product product) throws DBException {
        try(DBConnection db = DBConnection.open()) {
            ProductDAO productDAO = db.productDAO();
            productDAO.save(product);
            db.commit();
        }
    }

    @WebResult(name="customer")
    public Customer oneCustomer(@WebParam(name="email") String email) throws DBException, RecordNotFound {
        try(DBConnection db = DBConnection.open()) {
            CustomerDAO customerDAO = db.customerDAO();
            return customerDAO.findByEmail(email);
        }
    }

    @WebResult(name="order")
    public Order oneOrder(@WebParam(name="id") int orderId) throws DBException, RecordNotFound {
        try(DBConnection db = DBConnection.open()) {
            OrderDAO orderDAO = db.orderDAO();
            return orderDAO.findById(orderId);
        }
    }

    @WebResult(name="bytes")
    public byte[] getPhoto(@WebParam(name="id") int productId) throws DBException, RecordNotFound {
        return PhotoUtil.readBytes(productId);
    }

    public void savePhoto(@WebParam(name="id") int productId,
                          @WebParam(name="bytes") byte[] bytes) {
        PhotoUtil.writeBytes(productId, bytes);
    }
}
