package niskopoziomowe;

import jakarta.annotation.Resource;
import jakarta.servlet.ServletContext;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import jakarta.xml.ws.Provider;
import jakarta.xml.ws.WebServiceContext;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.WebServiceProvider;
import jakarta.xml.ws.handler.MessageContext;

import org.w3c.dom.Node;

@WebServiceProvider(wsdlLocation="WEB-INF/wsdl/Kalkulator.wsdl",
    targetNamespace="http://kalkulator.pl",
    serviceName="Kalkulator", portName="KalkulatorXSLT")
public class RunXSLT implements Provider<Source> {
    @Resource
    private WebServiceContext wsContext;

    public Source invoke(Source request) {
        try {
            ServletContext servletContext = (ServletContext) wsContext.getMessageContext().get(MessageContext.SERVLET_CONTEXT);
            StreamSource xslt = new StreamSource(servletContext.getResourceAsStream("kalkulator.xsl"));

            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer tr = tf.newTransformer(xslt);
            DOMResult result = new DOMResult();
            tr.transform(request, result);
            Node dom = result.getNode();
            DOMSource ultimateResult = new DOMSource(dom);
            return ultimateResult;
        } catch (Exception e) {
            throw new WebServiceException("XSLTProvider error",e);
        }
    }
}
