package hello;

import jakarta.jws.WebParam;
import jakarta.jws.WebResult;
import jakarta.jws.WebService;
import jakarta.xml.ws.RequestWrapper;
import jakarta.xml.ws.ResponseWrapper;

import java.time.LocalTime;

// JAX-WS - usługi typu SOAP w Javie (obecnie element Jakarta EE)
@WebService
public class PierwszaUsluga {
    public String hello() {
        return "Hello World!";
    }

    public String witaj(String imie) {
        return "Witaj " + imie;
    }

    @WebResult(name="biezacy-czas")
    public String ktoraGodzina() {
        return LocalTime.now().toString();
    }

    @RequestWrapper(localName="kalkulator")
    @ResponseWrapper(localName="kalkulatorResponse")
    @WebResult(name="wynik")
    public long oblicz(@WebParam(name="x") long liczba1,
                       @WebParam(name="y") long liczba2,
                       @WebParam(name="operacja") String operacja) {
        return switch(operacja) {
            case "+" -> liczba1 + liczba2;
            case "-" -> liczba1 - liczba2;
            case "*" -> liczba1 * liczba2;
            case "/" -> liczba1 / liczba2;
            default -> throw new IllegalArgumentException("nieznana operacja " + operacja);
        };
    }

}
