<%@page contentType="text/html;charset=UTF-8" language="java" %>
<%@taglib prefix="c" uri="jakarta.tags.core" %>
<html>
<head>
    <title>Title</title>
</head>
<body>
<h1>Przykładowa strona JSP</h1>

<p>Zwykła treść HTML.</p>
<p>Wynik operacji Java: <%= java.time.LocalTime.now() %></p>
<p>Wynik wyrażenia EL: ${2+3*4}</p>

<form>
    <label for="imie">Podaj imię:</label>
    <input type="text" name="imie" id="imie">
    <br>
    <button>Wyślij</button>
</form>

<h3>Skryptlety - różne wersje</h3>
<!-- To jest komentarz HTML - on będzie wysłany do klienta -->
<%-- To jest komentarz w JSP. Klient tego nie zobaczy --%>

<%-- Fragmenty HTML i zwykłego tekstu pisane w JSP są wysyłane w odpowiedzi do klienta.
    Ale w plikach JSP można też umieszczać fragmenty kodu Java wewnątrz tzw. scriptlets. --%>
<p>Zaraz wykonam kod Javy:</p>
<%
    out.println("Hej, tu Java wewnątrz JSP");
    System.out.println("a kuku");
    int x = 321;
    String[] imiona = {"Ala", "Ola", "Ela"};
%>
<p>Znowu tryb HTML</p>

<%-- brzydki styl, ale działa: --%>
<ul>
    <% for(String imie : imiona) { %>
        <li><%= imie%></li>
    <% } %>
</ul>

<%-- Istnieją specjalne wersje skryptletów.
   Powyżej widzielismy zwykły blok kodu.
   Poniżej zobaczymy wstawienie wartości do outputu: --%>
<p>Wypisanie wyniku: <%= 2*x %></p>
<p>Odczyt czasu: <%= java.time.LocalTime.now() %></p>
<p>Prametr imie: <%= request.getParameter("imie") %></p>

<%!
    static int licznik = 100;
    String dajGlos() {
        return "hau hau";
    }
%>
<p>Licznik: <%= licznik++ %></p>
<p>Metoda: <%= dajGlos() %></p>

<%-- Plik JSP jest na serwerze tłumaczony na klasę serwletu i kompilowany. --%>

<h2>Inne sposoby</h2>
<p>Mądrzejszy sposób korzystania z JSP łączy takie trzy techniki:</p>
<ol>
    <li><strong>Expression Language (EL)</strong> - wyrażenia wpisywane w znacznikach <code>$ { }</code>,
    <li><strong>beans</strong> - obiekty przygotowane po stronie aplikacji lub w samym skrypcie JSP, do których JSP ma dostęp,
    <li><strong>taglibs</strong> - biblioteki dodatkowych tagów, które działają jak polecenia, chociaż są pisane jak tagi HTML.
</ol>


<h3>EL</h3>
<%-- proste wyrażenie EL --%>
<p>Wynik obliczenia: ${2 + 3 * 4}</p>
<p>Parametr imie: <strong>${param.imie}</strong></p>

<jsp:useBean id="obiekt" class="serwlety.beans.PrzykladowyBean"/>

<p>Obiekt beanowy: ${obiekt}</p>
<p>Napis: ${obiekt.napis}</p>
<p>Napis DL: ${obiekt.napisDuzymiLiterami}</p>
<%-- <p>Napis: ${obiekt.liczba}</p> -->

<%-- Można wywoływać metody o nazwach niezgodnych z konwencją getterów: --%>
<p>Wywołanie metody: ${obiekt.wylosuj()}</p>

<jsp:setProperty property="napis" name="obiekt" value="Ola ma psa"/>
<p>Napis po zmianie: ${obiekt.napis}</p>
<p>Duże litery: ${obiekt.napisDuzymiLiterami}</p>
<%-- Gdy wpisujemy odwołanie do obiektu, to jest on printowany za pomocą toString().
    Gdy wpiszemy coś, co wygląda na odczyt pola obiektu, to jest wywoływany getter zwracający to property,
    np. osoba.wiek powoduje wywołanie getWiek()
    Gdy wpiszemy coś z nawiasami na końcu, to jest to wywołanie metody.
    Polecenie setProperty skutkuje wywołaniem settera, np. setNapis(...)
--%>

<%-- Biblioteka tagów ("taglib") to jest zestaw poleceń zapisywanych w formie znaczników w obrębie JSP.
Te znaczniki zawsze są poprzedzane prefiksem, np. <c:if>....

Tagliby można definiować samodzielnie, ale w 98% przypadków używa się zestawu nazywanego JSTL
"Java Standard Tag Library"
--%>
<h3>Taglibs</h3>
<ul>
    <c:forEach var="i" items="5,10,15">
        <li>${i}
            <c:choose>
                <c:when test="${i % 2 == 0}">parzyste</c:when>
                <c:otherwise>nieparzyste</c:otherwise>
            </c:choose>
        </li>
    </c:forEach>
</ul>

<p>Słowa napisu:</p>
<ul>
    <c:forEach var="word" items="${obiekt.words}">
        <li>${word}</li>
    </c:forEach>
</ul>

</body>
</html>
