package serwlety.rozmowa;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

import java.io.IOException;
import java.io.PrintWriter;

@WebServlet("/rozmowa")
public class Rozmowa extends HttpServlet {

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String imie = request.getParameter("imie");
        String data = request.getParameter("data");
        // jeśli podano parametry, to ich wartości dostajemy w formie Stringów
        // jeśli nie podano parametrów, bo np. jest to pierwsze wyświetlenie strony, to getParameter zwraca wynik null

        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();

        String html = """
        <!DOCTYPE html>
        <html>
        <head>
        <title>Rozmowa serwletowa</title>
        </head>
        <body>
        <h1>Rozmowa serwletowa</h1>
        <form>
        <label for="imie">Jak masz na imię?</label>
        <input type="text" name="imie" id="imie">
        <br>
        <label for="data">Data urodzenia</label>
        <input type="date" name="data" id="data">
        <br>
        <button>Wyślij</button>
        </form>
        """;
        out.println(html);

        if(imie != null && !imie.isBlank()) {
            out.println("<div>Witaj " + imie + "!</div>");
            if(data != null && !data.isBlank()) {
                out.println("<br>Podałeś datę " + data);
            }
        }

        out.println("</body></html>");
    }
}
