package serwlety.kalkulator;

import java.io.IOException;
import java.io.PrintWriter;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

@WebServlet("/kalkulator4")
public class Kalkulator4 extends HttpServlet {

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = wyslijNaglowkiIPobierzWritera(response);
        poczatekHtml(out);
        formularz(out);
        koniecHtml(out);
    }
    
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = wyslijNaglowkiIPobierzWritera(response);
        poczatekHtml(out);
        formularz(out);
        pobierzParametryIWstawWynik(request, out);
        koniecHtml(out);
    }

    private PrintWriter wyslijNaglowkiIPobierzWritera(HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        return response.getWriter();
    }

    private void poczatekHtml(PrintWriter out) {
        out.println("<!DOCTYPE html>");
        out.println("<html><head>");
        out.println("<title>Kalkulator serwletowy</title>");
        out.println("<link rel='stylesheet' type='text/css' href='styl.css'>");
        out.println("</head>");
        out.println("<body>");
        out.println("<h1>Kalkulator</h1>");
    }

    private void formularz(PrintWriter out) {
        out.println("<form method='post'>");
        out.println("<input type='number' name='liczba1'>");
        out.println("<select name='operacja'>");
        out.println("<option value='+'>+</option>");
        out.println("<option value='-'>-</option>");
        out.println("<option value='*'>*</option>");
        out.println("<option value='/'>/</option>");
        out.println("</select>");		
        out.println("<input type='number' name='liczba2'>");
        out.println("<button>Oblicz</button>");
        out.println("</form>");
    }

    private void koniecHtml(PrintWriter out) {
        out.println("</body>");
        out.println("</html>");
    }

    private void pobierzParametryIWstawWynik(HttpServletRequest request, PrintWriter out) {
        String param1 = request.getParameter("liczba1");
        String param2 = request.getParameter("liczba2");
        String operacja = request.getParameter("operacja");
        
        try {
            long liczba1 = Long.parseLong(param1);
            long liczba2 = Long.parseLong(param2);
            long wynik = LogikaKalkulatora.oblicz(liczba1, liczba2, operacja);
            out.printf("<div class='wynik'>%d %s %d = <strong>%d</strong></div>\n",
                    liczba1, operacja, liczba2, wynik);
        } catch (NumberFormatException e) {
            out.printf("<div class='error'>Niepoprawny format liczby</div>\n");
        } catch(Exception e) {
            out.printf("<div class='error'>Błąd: %s</div>\n", e.getMessage());				
        }
    }
}
