package serwlety.kalkulator;

import java.io.IOException;
import java.io.PrintWriter;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

@WebServlet("/kalkulator1")
public class Kalkulator1 extends HttpServlet {

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        out.println("<!DOCTYPE html>");
        out.println("<html><head>");
        out.println("<title>Kalkulator serwletowy</title>");
        out.println("</head>");
        out.println("<body>");
        out.println("<h1>Kalkulator</h1>");
        out.println("<form>");
        out.println("<label for='liczba1'>Liczba 1:</label>");
        out.println("<input type='number' name='liczba1'>");
        out.println("<label for='liczba2'>Liczba 2:</label>");
        out.println("<input type='number' name='liczba2'>");
        out.println("<button>Dodaj</button>");
        out.println("</form>");
        
        String parametr1 = request.getParameter("liczba1");
        String parametr2 = request.getParameter("liczba2");
        if(parametr1 != null && parametr2 != null) {
            try {
                long liczba1 = Long.parseLong(parametr1);
                long liczba2 = Long.parseLong(parametr2);
                long wynik = liczba1 + liczba2;
                out.println("<div>" + liczba1 + " + " + liczba2 + " = " + wynik + "</p>");
            } catch (Exception e) {
                out.println("<div>Błąd: " + e + "</div>");
            }
        }
        out.println("</body>");
        out.println("</html>");	
    }

}
