package serwlety.hello;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

@WebServlet("/time")
public class KtoraGodzina extends HttpServlet {

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        // Gdy na serwer pod adres adres_aplikacji/time przyjdzie zapytanie,
        // to ta klasa zajmie się obsługą tego zapytania.
        // Jeśli jest to zapytanie typu GET, to serwer wywoła tę metodę,
        // w parametrze request zostaną przekazane informacje o zapytania (m.in. parametry, nagłówki, ciasteczka)
        // poprzez obiekt response mamy zbudować odpowiedź
        response.setContentType("text/plain");
        // response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        out.println("Teraz jest <strong>późna</strong> godzina " + LocalTime.now());

        DateTimeFormatter format = DateTimeFormatter.ofPattern("HH:mm:ss");
        out.println("Czas sformatowany:  " + LocalTime.now().format(format));

    }
}
