package serwlety.beans;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/* Klasa jest "Java Bean" jeśli:
 * 1) posiada publiczny konstruktor bezargumentowy (tzw. "default constructor")
 * 2) dostęp do własności ("properties") udostępniony poprzez gettery i settery (nie ma obowiązku aby zawsze była para)
 * ... wzorzec Java Bean opisuje też technikę powiadamiania o zdarzeniach (korzysta się z tego przede wszystkim w GUI), ale w większości przypadków wystarczają te dwie powyższe cechy 
 */

// konstruktor domyślny jest tworzony automatycznie

public class ExampleBean {
    private String napis = "Ala ma kota";
    private int licznik = 0;
    private final List<String> lista = new ArrayList<>(List.of("Warszawa", "Kraków", "Wrocław", "Gdańsk"));
    
    public String getNapis() {
        return napis;
    }
    
    public void setNapis(String napis) {
        this.napis = napis;
    }
    
    public synchronized int getLicznik() {
        return ++licznik;
    }
    
    public void setLicznik(int licznik) {
        this.licznik = licznik;
    }
    
    // Metoda może wyglądać jak getter, ale zamiast po prostu zwracać wartość pola z obiektu,
    // może pobrać dane z innego źródła: bieżący czas, dane z pliku, z bazy danych, obliczona na podstawie innych wartości.
    // W skryptach JSP, Thymeleaf itp. można ten getter wywołać pisząc bean.currentTime
    public LocalDateTime getCurrentTime() {
        return LocalDateTime.now();
    }

    public List<String> getLista() {
        return lista;
    }
    
    @Override
    public String toString() {
        return "ExampleBean z napisem " + napis + " i aktualną wartością licznika " + licznik;
    }



}
