package na_zajeciach.podstawy;

import java.math.BigDecimal;
import java.sql.*;

// JDBC Java Database Connectivity
public class OdczytajOsoby {
    public static void main(String[] args) {
        try(Connection c = DriverManager.getConnection("jdbc:postgresql://localhost:5432/alx",
                "alx", "abc123")) {
            System.out.println("Mam połączenie: " + c);

            try(PreparedStatement stmt = c.prepareStatement("SELECT * FROM osoby");
                ResultSet rs = stmt.executeQuery()) {
                while(rs.next()) {
                    int id = rs.getInt(1); // albo rs.getInt("id");
                    String imie = rs.getString("imie");
                    String nazwisko = rs.getString("nazwisko");
                    Date dataUr = rs.getDate("data_ur");
                    BigDecimal pensja = rs.getBigDecimal("pensja");
                    System.out.printf("%d: %s %s, ur. %s, pensja: %s%n", id, imie, nazwisko, dataUr, pensja);
                }
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}
