package gotowe.postgresql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class P13e_Blob_Show {

    public static void main(String[] args) {
        String sql = "SELECT photo_id, file_name, bytes FROM photos ORDER BY 1";
        
        try(Connection c = DriverManager.getConnection(Ustawienia.URL, Ustawienia.USER, Ustawienia.PASSWD)) {
            c.setAutoCommit(false);
            c.setReadOnly(true);

            try(PreparedStatement stmt = c.prepareStatement(sql);
                ResultSet rs = stmt.executeQuery()) {
                while(rs.next()) {
                    int id = rs.getInt(1);
                    String fileName = rs.getString(2);
                    byte[] bytes = rs.getBytes(3);
                    ImageIcon img = new ImageIcon(bytes);
                    JOptionPane.showMessageDialog(null, img, "Zdjęcie nr " + id, JOptionPane.INFORMATION_MESSAGE);
                }
            }
            JOptionPane.showMessageDialog(null, "Gotowe");
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

}
