package gotowe.postgresql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class P07_GenerowaneId {
    /* W bazach danych często stosowane są automatycznie generowane klucze. Gdy wykonujemy polecenie INSERT nie wymieniając kolumny z kluczem,
     * jego wartość jest generowana automatycznie (z sekwencji lub w oparciu o specjalny typ kolumny).
     * Ale aplikacja zwykle potrzebuje poznać to ID, aby móc odwoływać się do tego rekordu w dalszej części programu.
     * JDBC oferuje mechanizm, w którym przed wykonaniem operacji INSERT w obiekcie Statement rejestruje się automatycznie generowane kolumny,
     * a po wykonaniu polecenia można pobrać ich wartości (jako ResultSet).
     * W praktyce chodzi o takie kolumny, jak autoinkrementowane ID (przede wszystkim), czas utworzenia rekordu, czasami inne wartości domyślne.
     * Tu dodatkowo używam state_province, co jest o tyle nieciekawe, że tam po prostu będzie null,
     * ale po prostu pokazuję, że tych pól można podać więcej niż jedno.
     */

    public static void main(String[] args) {
//   	 Tablica nazw kolumn, których wartości są wstawiane automatycznie.
//   	 Zamiast nazw mogą być też numery (wtedy tablica intów).
     String[] polaGenerowane = {"location_id", "state_province"};
     String sql = "INSERT INTO locations(street_address, postal_code, city, country_id) VALUES(?, ?, ?, ?)";

        try(Connection c = DriverManager.getConnection(Ustawienia.URL, Ustawienia.USER, Ustawienia.PASSWD);
         PreparedStatement stmt = c.prepareStatement(sql, polaGenerowane)) {

         stmt.setString(1, "Nowa z " + LocalTime.now().format(DateTimeFormatter.ofPattern("HH:mm:SS")));
         stmt.setString(2, "01-321");
         stmt.setString(3, "Warszawa");
         stmt.setString(4, "US");

         int ile = stmt.executeUpdate();
         System.out.println("Wstawiono " + ile + " rekord"); // powinno być 1

         // odcyt wartości wygenerowanych pól
         try(ResultSet rsGen = stmt.getGeneratedKeys()) {
             if(rsGen.next()) {
                 int id = rsGen.getInt(1);
                 String state = rsGen.getString(2);
                 System.out.println("wygenerowane wartości pól: " + id + ", " + state);
             }
         }
        } catch (SQLException e) {
         e.printStackTrace();
        }
    }
}
