package na_zajeciach.podstawy;

import javax.swing.*;
import java.math.BigDecimal;
import java.sql.*;

// Zadanie: niech program wypisuje tylko tych pracowników, którzy mają podane job_id
// Rozwiązanie poprawne:
// - Dzięki WHERE to serwer wybiera tylko te rekordy, które spełniają warunek.
//   * Jeśli dla kolumny jest zdefiniowany indeks, to serwer bardzo sprawnie odczyta z dysku tylko te rekordy, które mają sens (dla dużych danych to jest olbrzymie przyspieszenie)
//   * Nawet gdyby nie było indeksu, to sprawdzanie warunku po stronie serwera zmniejsza transfer i obciążenie naszej aplikacji klienckiej.
// - Dzięki podstawianiu parametrów za pomocą ? jest to bezpieczne - nie ma możliwości SQL Injection (oczywiście o ile twórcy sterownika postgresql-jdbc dobrze go napisali...)

public class PracownicyWedlugJob3 {
    public static void main(String[] args) {
        try(Connection c = DriverManager.getConnection("jdbc:postgresql://localhost:5432/hr", "alx", "abc123")) {
            String szukanyJob = JOptionPane.showInputDialog("Podaj nazwę stanowiska", "IT_PROG");

            try(PreparedStatement stmt = c.prepareStatement("SELECT * FROM employees WHERE job_id = ?")) {
                stmt.setString(1, szukanyJob);
                System.out.println(stmt);
                try(ResultSet rs = stmt.executeQuery()) {
                    while(rs.next()) {
                        String job = rs.getString("job_id");
                        String imie = rs.getString("first_name");
                        String nazwisko = rs.getString("last_name");
                        BigDecimal pensja = rs.getBigDecimal("salary");
                        System.out.printf("%s %s (%s) zarabia %s%n", imie, nazwisko, job, pensja);
                    }
                }
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}
