package na_zajeciach.podstawy;

import javax.swing.*;
import java.sql.*;

public class ModyfikacjaWTransakcji {

    public static void main(String[] args) {
        final String updateSql = "UPDATE employees SET salary = salary + ? WHERE job_id = ?";
        final String avgSql = "SELECT avg(salary) FROM employees WHERE job_id = ?";

        try(Connection c = DriverManager.getConnection("jdbc:postgresql://localhost/hr", "alx", "abc123")) {
            PreparedStatement updateStmt = c.prepareStatement(updateSql);
            PreparedStatement avgStmt = c.prepareStatement(avgSql);

            c.setAutoCommit(false);
            // weszliśmy w tryb transakcji, tzn. zmiany dokonywane w tej sesji nie będą zapisane w sposób trwały dopóki nie wykonamy polecenia COMMIT
            // zerwanie sesji bez zrobienia COMMIT powoduje utratę zmian

            String szukanyJob = JOptionPane.showInputDialog("Podaj kod stanowiska", "IT_PROG");
            avgStmt.setString(1, szukanyJob);
            try(ResultSet rs = avgStmt.executeQuery()) {
                if(rs.next()) {
                    double avg = rs.getDouble(1);
                    JOptionPane.showMessageDialog(null, "Średnia pensja wynosi " + avg);
                }
            }

            int zmiana = Integer.parseInt(JOptionPane.showInputDialog("Podaj zmianę pensji", "1000"));
            updateStmt.setInt(1, zmiana);
            updateStmt.setString(2, szukanyJob);
            int wynik = updateStmt.executeUpdate();
            JOptionPane.showMessageDialog(null, "Zmieniono " + wynik + " rekordów.");
            try(ResultSet rs = avgStmt.executeQuery()) {
                if(rs.next()) {
                    double avg = rs.getDouble(1);
                    JOptionPane.showMessageDialog(null, "Średnia pensja wynosi teraz " + avg);
                }
            }

            int wybor = JOptionPane.showConfirmDialog(null, "Czy zapisać zmiany?");
            switch(wybor) {
                case JOptionPane.YES_OPTION -> c.commit();
                case JOptionPane.NO_OPTION -> c.rollback();
                case JOptionPane.CANCEL_OPTION -> {return;} // wcześniej przerywa program; połączenie zostanie zamknięte bez commita
            }

            try(ResultSet rs = avgStmt.executeQuery()) {
                if(rs.next()) {
                    double avg = rs.getDouble(1);
                    JOptionPane.showMessageDialog(null, "Średnia pensja wynosi teraz " + avg);
                }
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}
