package watki.na_zajeciach;

public class Konto {
    private final int numer;
    private final String wlasciciel;
    private int saldo;

    public Konto(int numer, String wlasciciel, int saldo) {
        this.numer = numer;
        this.wlasciciel = wlasciciel;
        this.saldo = saldo;
    }

    public int getNumer() {
        return numer;
    }

    public String getWlasciciel() {
        return wlasciciel;
    }

    public int getSaldo() {
        return saldo;
    }

    @Override
    public String toString() {
        return "Konto nr " + numer + ", wł: " + wlasciciel + ", saldo: " + saldo;
    }

    public synchronized void wplata(int kwota) {
        if(kwota <= 0) {
            throw new IllegalArgumentException("Kwota nie jest dodatnia!");
        }
        saldo += kwota;
        notify();
    }

    public synchronized void wyplata(int kwota) {
        if(kwota <= 0) {
            throw new IllegalArgumentException("Kwota nie jest dodatnia!");
        }
        if(kwota > saldo) {
            throw new RuntimeException("Brak środków!");
        }
        saldo -= kwota;
    }

    public synchronized void wyplataCzekaj(int kwota) {
        if(kwota <= 0) {
            throw new IllegalArgumentException("Kwota nie jest dodatnia!");
        }
        try {
            while(kwota > saldo) {
                wait();
            }
            saldo -= kwota;
            notify();
        } catch (InterruptedException e) {
        }
    }
}
