package p30_swing.zdarzenia;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

// Ta wersja jest porządniej napisania
// - zmienne nie są definiowane w mainie, tylko są polami obiektu.
// Dzięki temu jest do nich łatwy dostep z róznych metod.

// Aby uruchomić program, tworzony jest obiekt tej klasy.

public class Rozmowa_Obiektowo {
	private static final Font FONT = new Font("Arial", Font.BOLD, 32);
	private static final Dimension odstep = new Dimension(0, 10);

	private JFrame okno;
	private JPanel panel;
	private JLabel pytanie;
	private JTextField pole;
	private JButton guzik;
	private JLabel powitanie;
	private JButton guzik2;

	public static void main(String[] args) {
		new Rozmowa_Obiektowo().run();
	}

	public void run() {
		przygotujWyglad();
		przygotujZdarzenia();
		wyswietl();

		System.out.println("okno wyświetlone, koniec main");
	}

	private void przygotujWyglad() {
		okno = new JFrame("Rozmowa");
		okno.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		panel = new JPanel();
		okno.setContentPane(panel); // panel jest wnętrzem okna

		// panel.setBorder(BorderFactory.createLineBorder(Color.BLUE, 5));
		panel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));

		LayoutManager layout = new BoxLayout(panel, BoxLayout.Y_AXIS);
		panel.setLayout(layout);

		pytanie = new JLabel("Jak masz na imię?");
		pytanie.setFont(FONT);
		pytanie.setForeground(Color.BLACK);
		panel.add(pytanie);

		panel.add(Box.createRigidArea(odstep));

		pole = new JTextField();
		pole.setFont(FONT);
		pole.setForeground(Color.RED);
		panel.add(pole);

		panel.add(Box.createRigidArea(odstep));

		guzik = new JButton("OK");
		guzik.setFont(FONT);
		guzik.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
		panel.add(guzik);

		panel.add(Box.createRigidArea(odstep));

		powitanie = new JLabel("Witaj");
		powitanie.setFont(FONT);
		powitanie.setForeground(Color.BLUE);
		panel.add(powitanie);

		panel.add(Box.createRigidArea(odstep));

		guzik2 = new JButton("Niespodzianka");
		guzik2.setFont(FONT);
		guzik2.setForeground(Color.RED);
		guzik2.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
		panel.add(guzik2);

		panel.add(Box.createRigidArea(odstep));
		okno.pack();
	}

	private void wyswietl() {
		okno.setVisible(true);
	}

	private void przygotujZdarzenia() {
		// aby obsługiwać zdarzenia, tworzymy obiekt listener i rejestrujemy go w guziku
		// MojListener listener = new MojListener();
		// guzik.addActionListener(listener);

		// w praktyce listenery najczęściej tworzy się bezpośrednio w klasie okna
		// za pomocą składni "klasa anonimowa" (lub od Javy 8 - "wyrażenie lambda")

		guzik.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				// Dzięki temu, że teraz jestem w tej samej klasie i mam dostęp do zmiennych
				// pole, guzik itp., mogę zmienić zawartość i wygląd okna.
				String imie = pole.getText();
				powitanie.setText("Witaj " + imie);
				powitanie.setForeground(Color.BLUE);
			}
		});
		
		// Również do pola tekstowego można dodać obsługę zdarzeń - to będzie zdarzenie "naciśnięcia ENTER"
		
		pole.addActionListener(evt -> {
			String imie = pole.getText();
			powitanie.setText("Halo " + imie);
			powitanie.setForeground(Color.GREEN);
		});
		
		Random random = new Random();

		guzik2.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				powitanie.setForeground(Color.GREEN);

				okno.getContentPane().setBackground(new Color(random.nextInt(0x1000000)));

				int x = okno.getX() + random.nextInt(400) - 200;
				int y = okno.getY() + random.nextInt(400) - 200;
				okno.setLocation(x, y);
			}
		});
	}
}
