package p30_swing.podstawy;

import java.awt.Color;
import java.awt.Font;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingConstants;

public class Kolory {
	// Za pomocą metod setXXX można zmieniać własności komponentów graficznych, np.
	// kolor, rozmiar, itd....
	public static void main(String[] args) {
		JFrame frame = new JFrame("Nasza apka");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setSize(600, 400);
		
		// Gdybyśmy chcieli zmienić kolor tła całego okna, to w taki sposób:
		// frame.getContentPane().setBackground(Color.PINK);

		JLabel label1 = new JLabel("Ala ma kota.");
		label1.setHorizontalAlignment(SwingConstants.CENTER); // domyślnie jest LEADING
		label1.setVerticalAlignment(SwingConstants.CENTER); // domyślnie jest CENTER
		label1.setForeground(Color.BLUE);
		// label1.setForeground(new Color(0, 0, 255, 128));
		label1.setFont(new Font("Arial", Font.BOLD, 40));

		// Aby zmienić kolor tła nie wystarczy setBackground
		// W przypadku Label itp. komponentów trzeba jeszcze wyłączyć przezroczystość.
		label1.setOpaque(true);

		// Jeśli chcemy zdefiniować mniej standardowy kolor, to istnieje kilka sposobów:
		Color kolorTla;

		// gotowa stała
		// kolorTla = Color.YELLOW;
		
		// podając wartości trzech "kanałów", czyli trzech barw podstawowych: Red Green Blue
		// trzy liczby typu float z zakresu od 0.0 do 1.0
		// kolorTla = new Color(0.8f, 1.0f, 0.5f);

		// trzy liczby całkowite z zakresu od 0 do 255
		kolorTla = new Color(255, 240, 128);

		// Czwarty parametr oznacza kanał alfa - stopień przezroczystości (0-przezroczyste 255-nieprzezroczyste) - to ma sens gdy nakładamy kilka obrazów (warstw) na siebie
		//kolorTla = new Color(255, 240, 128, 128);

		// jedna liczba całkowita, która zapis szesnastkowy odpowiada takiemu kodowaniu:
		// 0xRRGGBB gdzie RR GG BB to są wartości poszczególnych barw, każda w zakresie
		// od 00 do FF
		// kolorTla = new Color(0xFFF080);

		// można też odkodować zapis CSS-owy
		//kolorTla = Color.decode("#FFF080");

		label1.setBackground(kolorTla);

		frame.add(label1);

		frame.setVisible(true);
	}

}
