package p08_funkcje.teoria;

import javax.swing.JOptionPane;

public class C_Return {

	public static void main(String[] args) {
		System.out.println("Początek main");
		
		// Funkcja zwraca wynik (return).
		// Samo wywołanie funkcje nie powoduje wypisanie tego wyniku na ekran.
		// Wynik można "odebrać", np. wpisując do zmiennej.
		String tekst = dajTekst("Java");
		// Teraz w zmiennej tekst znajduje się tekst zwrócony przez funkcję
		System.out.println("Funkcja dajTekst się zakończyła. Wynikowy tekst:");
		// Dopiero teraz ten tekst wypiszemy:
		System.out.println(tekst);
		
		// Teraz wywołamy funkcję, ale wynik zignorujemy, w ogóle nigdzie go nie będzie
		dajTekst("C++");
		
		// można też od razu wypisać wynik:
		System.out.println(dajTekst("Python"));
		System.out.println();
		
		// zignorowanie wyniku:
		kwadrat(3); // 9 nigdzie się nie wypisze
		
		// zapisanie wyniku do zmiennej:
		var wynik = kwadrat(6);
		System.out.println("kwadrat liczby 6 to jest " + wynik);
		
		// od razu wypisać:
		System.out.println("7² = " + kwadrat(7));

		// jeśli funkcja daje w wyniku liczbę, to można jej użyć w większym wyrażeniu
		wynik = 10 * (kwadrat(3) + kwadrat(4));
		System.out.println(wynik);
		
		System.out.println("abs(5) = " + abs(5));
		System.out.println("abs(0) = " + abs(0));
		System.out.println("abs(-3) = " + abs(-3));
		
		// Gdy funkcja zwróci wynik, możemy z nim zrobić dowolne rzeczy, nie tylko wypisać go na ekran.
		JOptionPane.showMessageDialog(null, "Wynik podnoszenia do kwadratu: " + kwadrat(13));
	}
	
	static String dajTekst(String jezyk) {
		return "Język " + jezyk + " jest najlepszy na świecie.";
	}
	
	static long kwadrat(int a) {
		return (long)a*a;
	}
	
	// return może występować nie tylko na samym końcu; może być więcej niż jeden return w funkcji
	// ALE
	// - gdy nastąpi return, to funkcja w tym momencie jest kończona ("zwraca podany wynik i kończy się")
	// - niezależnie od ścieżki, którą podąży program, funkcja MUSI zwrócić wynik
	static int abs(int liczba) {
		if(liczba >= 0) {
			return liczba;
		} else {
			return -liczba;
		}
	}

}
