package emps.v4_rekordy;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class GrupowanieMerge {

    public static void main(String[] args) {
        List<Employee> emps = ObslugaCSV.wczytajDane();
        
        Map<String, Integer> sumy = new TreeMap<>();
        Map<String, Integer> ilosci = new TreeMap<>();
        for(Employee emp : emps) {
            sumy.merge(emp.jobTitle(), emp.salary(), Integer::sum);
            ilosci.merge(emp.jobTitle(), 1, Integer::sum);
        }
        
        for(String job : sumy.keySet()) {
            int suma = sumy.get(job);
            int ilosc = ilosci.get(job);
            double srednia = suma / ilosc;
            System.out.printf("| %-32s | %2d | %8.2f |\n", job, ilosc, srednia);
        }
    }

}
