package emps.v4_rekordy;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class GrupowanieMap {

    public static void main(String[] args) {
        List<Employee> emps = ObslugaCSV.wczytajDane();
        
        Map<String, Integer> sumy = new TreeMap<>();
        Map<String, Integer> ilosci = new TreeMap<>();
        for(Employee emp : emps) {
            int suma = sumy.getOrDefault(emp.jobTitle(), 0);
            sumy.put(emp.jobTitle(), suma + emp.salary());
            int ilosc = ilosci.getOrDefault(emp.jobTitle(), 0);
            ilosci.put(emp.jobTitle(), ilosc + 1);
        }
        
        for(String job : sumy.keySet()) {
            int suma = sumy.get(job);
            int ilosc = ilosci.get(job);
            double srednia = suma / ilosc;
            System.out.printf("| %-32s | %2d | %8.2f |\n", job, ilosc, srednia);
        }
    }

}
