package emps.v3_funkcyjnie;

import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class Grupowanie_f3 {

    public static void main(String[] args) {
        List<Employee> emps = ObslugaCSV.wczytajDane();
        
        // W tej wersji wyliczamy nie tylko średnią, ale ogólne "statystyki" (podobnie, jak w Grupowanie_v7).
        // Niezależnie od tego do kolektora groupingBy przekazuję też parametr TreeMap::new
        // co powoduje użycie TreeMap zamiast HashMap
        Map<String, IntSummaryStatistics> grupy = emps.stream().collect(
                Collectors.groupingBy(Employee::getJobTitle,
                        TreeMap::new,
                        Collectors.summarizingInt(Employee::getSalary)));

        grupy.forEach((job, stats) -> {
            // System.out.printf("%32s → %s%n", job, stats);
            System.out.printf("| %-32s | %2d | %5d | %8.2f | %5d |%n",
                    job, stats.getCount(), stats.getMin(), stats.getAverage(), stats.getMax());
        });
    }

}
