package emps.v3_funkcyjnie;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Grupowanie_f2 {

    public static void main(String[] args) {
        List<Employee> emps = ObslugaCSV.wczytajDane();
        
        // W tej wersji do groupingBy dodajemy parametr (kolejny collector) mówiący, co zrobić z każdą grupą.
        // Dla każdej grupy liczymy średnią pensję.
        Map<String, Double> grupy = emps.stream().collect(
                Collectors.groupingBy(Employee::getJobTitle,
                        Collectors.averagingInt(Employee::getSalary)));

        grupy.forEach((job, srednia) -> {
            System.out.printf("%32s → %8.2f%n", job, srednia);
        });
    }

}
