package emps.v3_funkcyjnie;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Grupowanie_f1 {

    public static void main(String[] args) {
        List<Employee> emps = ObslugaCSV.wczytajDane();
        
        // Dla podanego jobTitle, wartością jest lista tych pracowników, którzy mają takie jobTitle.
        Map<String, List<Employee>> grupy = emps.stream().collect(Collectors.groupingBy(Employee::getJobTitle));

        // Sposób wypisywania danych ze słownika dostępny od Java 8.
        grupy.forEach((job, lista) -> {
            System.out.println("Stanowisko " + job + ":");
            lista.forEach(emp -> {
                System.out.println(" * " + emp.getFirstName() + " " + emp.getLastName() + " " + emp.getSalary());
            });
            System.out.println();
        });
    }

}
