package emps.v3_funkcyjnie;

import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class F7_MiastaBezPowtorzen {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytajDane();
		
		// Podejście1: chcemy uzyskać kolekcję wartości bez powtórzeń → kolektor budujący zbiór
		Set<String> miasta = emps.stream()
			.map(Employee::getCity)
			.collect(Collectors.toSet());
		System.out.println(miasta);
		System.out.println();

		Predicate<String> pusty = String::isEmpty;
		Predicate<String> niepusty = pusty.negate();
		
		// Podejście2: chcemy wykonać operację, np. print, dla wartości bez powtórzeń → operacja pośrednia distinct
		emps.stream()
			.map(Employee::getCity)
			.filter(niepusty)
			.distinct()
			.forEach(System.out::println);
	}

}
