package emps.v3_funkcyjnie;

import java.util.Comparator;
import java.util.List;

public class F5_MinMax {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytajDane();
		
		// Aby uzyskać samą wartość, robimy podobnie jak w przypadku średniej
		int minSalary = emps.stream()
				.mapToInt(Employee::getSalary)
				.min()
				.orElse(0);
		System.out.println("Najmniejsza pensja " + minSalary);
		
		// Łatwo też jest uzyskać obiekty. Trzeba podać sposób porównywania, czyli Comparator.
		Employee min = emps.stream().min(Comparator.comparingInt(Employee::getSalary)).orElse(null);
		Employee max = emps.stream().max(Comparator.comparingInt(Employee::getSalary)).orElse(null);
		
		System.out.println("min: " + min);
		System.out.println("max: " + max);
	}

}
