package emps.v3_funkcyjnie;

import java.util.List;

public class F2_WypiszBogatych {

    public static void main(String[] args) {
        List<Employee> emps = ObslugaCSV.wczytajDane();
        
        System.out.println("BOGACI:");
        
        // Z kolekcji pobieramy "strumień" i na tym strumieniu wykonujemy operację filtrowania,
        // a następnie operację forEach → dla tych rekordów, które spełniły warunek filtrowania, zostanie wykonana operacja printf
        emps.stream()
            .filter(emp -> emp.getSalary() >= 10_000)
            .forEach(emp -> System.out.printf("Pracownik nr %d, %s %s (%s) zarabia %d\n",
                emp.getEmployeeId(), emp.getFirstName(), emp.getLastName(), emp.getJobTitle(), emp.getSalary()));
        
        // Po wykonaniu filter / forEach lista nadal zawiera wszystkie rekordy.
        // Operacje strumieniowe służą tylko do odczytuj danych. Nie modyfikują źródła danych - lista pozostaje bez zmian.
        
        // Ogólnie taka konstrukcja w kodzie nazywa się "pipeline":
        // - źródło_danych
        // - operacje pośrednie (intermediate operation, może być wiele kroków), np: map (różne wersje), filter, limit, sorted, distinct, ...
        // - operacja końcowa (terminal operation), np: forEach, forEachOrdered, reduce, collect, findFirst, ...
        
        System.out.println("\nBIEDNI:");
        
        emps.stream()
            .filter(emp -> emp.getSalary() < 5000)
            .map(emp -> String.format("%s %s (%s) zarabia %d", emp.getFirstName(),
                                    emp.getLastName(), emp.getJobTitle(), emp.getSalary()))
                // tutaj jest już strumień Stringów
            .map(String::toUpperCase)
            .forEach(System.out::println);
    }

}

