package emps.v2_obiektowo;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

public class ObslugaCSV {
    
    /** Wczytuje dane z domyślnej lokalizacji pliku. */
    public static List<Employee> wczytajDane() {
        return wczytajDane("pliki/emps.csv");
    }

    public static List<Employee> wczytajDane(String sciezka) {
        List<Employee> lista = new ArrayList<>();
        try(BufferedReader in = new BufferedReader(new FileReader(sciezka))) {
            String linia = in.readLine();
            // pierwszą linię ignorujemy - tam są nazwy kolumn
            while((linia = in.readLine()) != null) {
                String[] t = linia.split(";", -1);
                Employee emp = new Employee(Integer.parseInt(t[0]), t[1], t[2], t[3], Integer.parseInt(t[4]),
                        LocalDate.parse(t[5]), t[6], t[7], t[8], t[9], t[10]);
                lista.add(emp);
            }
        } catch(IOException e) {
            // W przypadku błędu wypiszemy info, ale nie przerywamy programu
            e.printStackTrace();
        }
        return lista;
    }
    
}
