package emps.v2_obiektowo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/* Tu wykorzystamy operację merge (od Java 8)
 * 
 * Operacja merge idealnie pasuje do schematu, który realizujemy w tym zadaniu.
 * slownik.merge(KLUCZ, WARTOSC, FUNKCJA)
 * - jeśli w słowniku nie ma jeszcze KLUCZa, to pod KLUCZ wpisywana jest WARTOSC
 * - jeśli w słowniku pod KLUCZ jest STARA_WARTOSC, to wykorzystywana jest FUNKCJA w taki sposób:
 *   NOWA_WARTOSC = FUNKCJA(STARA_WARTOSC, WARTOSC)
 *   a następne NOWA_WARTOSC wpisywana jest do słownika pod KLUCZ
 */

public class Grupowanie_v5 {

    public static void main(String[] args) {
        List<Employee> emps = ObslugaCSV.wczytajDane();
        
        Map<String, Integer> sumy = new HashMap<>();
        Map<String, Integer> ilosci = new HashMap<>();
        for(Employee emp : emps) {
            sumy.merge(emp.getJobTitle(), emp.getSalary(), Integer::sum);
            ilosci.merge(emp.getJobTitle(), 1, Integer::sum);
        }
        
        for(String job : sumy.keySet()) {
            int suma = sumy.get(job);
            int ilosc = ilosci.get(job);
            double srednia = suma / ilosc;
            System.out.printf("| %-32s | %2d | %8.2f |\n", job, ilosc, srednia);
        }
    }

}
