package emps.v2_obiektowo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/* Tu wykorzystamy operacje putIfAbsent / computeIfPresent (od Java 8) */

public class Grupowanie_v4 {

    public static void main(String[] args) {
        List<Employee> emps = ObslugaCSV.wczytajDane();
        
        Map<String, Integer> sumy = new HashMap<>();
        Map<String, Integer> ilosci = new HashMap<>();
        for(Employee emp : emps) {
            // Gdyby jeszcze nie było wartości pod tym kluczem, wpisujemy zera
            sumy.putIfAbsent(emp.getJobTitle(), 0);
            ilosci.putIfAbsent(emp.getJobTitle(), 0);
         
            // Za pomocą wyrażeń lambda określamy, w jaki sposób mają zostać zmienione wartośc.
            // Funkcja modyfikująca jako argumenty przyjmuje klucz oraz poprzednią wartość ze słownika, a w wyniku ma dać nową wartość
            sumy.computeIfPresent(emp.getJobTitle(), (job, suma) -> suma + emp.getSalary());
            ilosci.computeIfPresent(emp.getJobTitle(), (job, ilosc) -> ilosc+1);
        }
        
        for(String job : sumy.keySet()) {
            int suma = sumy.get(job);
            int ilosc = ilosci.get(job);
            double srednia = suma / ilosc;
            System.out.printf("| %-32s | %2d | %8.2f |\n", job, ilosc, srednia);
        }
    }

}
